using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using Outbound_OpenInterface_Test_App.OutboundCampaignWS;
using System.Web.Services.Protocols;

namespace Outbound_OpenInterface_Test_App
{
  public partial class Find_Contact : Form
  {
    OWCampaigns This_Campaign_List;
    int This_Selected_Index;

    public Find_Contact(OWCampaigns Campaign_List, int Selected_Index)
    {
      InitializeComponent();
      This_Campaign_List = Campaign_List;
      This_Selected_Index = Selected_Index;
      Campaign_Name_Field.Text = This_Campaign_List.CampaignList[This_Selected_Index].Name;
    }

    private void Find_By_Phone_Button_Click(object sender, EventArgs e)
    {
      OutboundContactWS.OutboundContactWS ConInvoke = new OutboundContactWS.OutboundContactWS();
      OutboundContactWS.OWPhoneNumber ContactNo = new OutboundContactWS.OWPhoneNumber();
       OutboundContactWS.OWStatus contactstatus = new Outbound_OpenInterface_Test_App.OutboundContactWS.OWStatus();


      ContactNo.AreaCode = Area_Code_Field.Text;
      ContactNo.IntCode = Int_Code_Field.Text;
      ContactNo.PhoneNo = Phone_No_Field.Text;


      OutboundContactWS.OWContacts result = new OutboundContactWS.OWContacts();
      try
      {
        result = ConInvoke.FindContactsByPhoneNumber(null, (int)This_Campaign_List.CampaignList[This_Selected_Index].ID, ContactNo, GlobalDef.getInstance().MySessionKey);

        if(result.ContactList != null)
        {
          foreach(OutboundContactWS.OWContact This_Contact in result.ContactList)
          {
            //do as you please here        
          }
          Message_Label.Text = result.ContactList.Length + " Contacts Found.";
        }
      }
      catch(Exception ex)
      {
        MessageBox.Show(ex.Message);
      }
    }

    private void Find_By_CF_Button_Click(object sender, EventArgs e)
    {
      OutboundContactWS.OutboundContactWS ConInvoke = new OutboundContactWS.OutboundContactWS();
      OutboundContactWS.OWCustomField CustomField = new OutboundContactWS.OWCustomField();

      CustomField.Name = Custom_Name_Field.Text;
      CustomField.Text = Custom_Value_Field.Text;

      OutboundContactWS.OWContacts result = new OutboundContactWS.OWContacts();
      try
      {
        result = ConInvoke.FindContactsByCustomField(null, (int)This_Campaign_List.CampaignList[This_Selected_Index].ID, CustomField, GlobalDef.getInstance().MySessionKey);

        if(result.ContactList != null)
        {
          foreach(OutboundContactWS.OWContact This_Contact in result.ContactList)
          {
            //do as you please here            
          }
          Message_Label.Text = result.ContactList.Length + " Contacts Found.";
        }
      }
      catch(Exception ex)
      {
        MessageBox.Show(ex.Message);
      }
    }
  }
}